/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp4;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.store.MaterialRequest;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.superplan.Superplan;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mrp {
    private static final Logger log = LoggerFactory.getLogger(Mrp.class);
    protected final EnumMap<GeneralizedOrderRequest.State, Integer> statesOrderingMap;
    protected final long priorityShift;
    protected final long unaddressedShift;
    protected final long opBuffer;
    protected final long bomStepBuffer;
    protected final long materialBuffer;
    protected final Map<Product, ProductInfo> prInfoMap;
    protected final Map<Material, MaterialInfo> matInfoMap;
    protected final Superplan superplan;
    protected int newGorsCnt;
    protected long processedGorsCnt;
    protected int newSrsCnt;
    protected long processedSrsCnt;
    protected final PropertyDefinition mrpOrderGorPd;
    protected final PropertyDefinition mrpOrderSrPd;
    protected ListMultimap<GeneralizedOrderRequest, Demand> feedsMap;

    protected Mrp(@Nonnull Superplan superplan) {
        this(superplan, new MrpParameters());
    }

    protected Mrp(@Nonnull Superplan superplan, MrpParameters parameters) {
        this.superplan = Preconditions.checkNotNull(superplan, "superplan cannot be null");
        this.statesOrderingMap = Preconditions.checkNotNull(parameters.statesOrderingMap, "GOR states score map cannot be null");
        this.priorityShift = parameters.priorityShift;
        this.unaddressedShift = parameters.unaddressedShift;
        this.opBuffer = parameters.opBuffer;
        this.bomStepBuffer = parameters.bomStepBuffer;
        this.materialBuffer = parameters.materialBuffer;
        this.prInfoMap = Maps.newHashMap();
        this.matInfoMap = Maps.newHashMap();
        this.mrpOrderGorPd = Mrp.optionalProperty(superplan, "mrpOrder", GeneralizedOrderRequest.class);
        this.mrpOrderSrPd = Mrp.optionalProperty(superplan, "mrpOrder", SupplyRequest.class);
        this.feedsMap = ArrayListMultimap.create();
        Preconditions.checkState(this.statesOrderingMap.size() == GeneralizedOrderRequest.State.values().length, "All GOR states must have score.");
    }

    protected List<Product> getSortedProducts() {
        return this.superplan.getShopConf().getSortedProducts();
    }

    protected void collectSrs() {
        for (SupplyRequest sr : this.superplan.getSupplyRequests()) {
            MaterialInfo info = this.getMaterialInfo(sr.getMaterial());
            if (info == null) continue;
            info.srs.add(sr);
        }
    }

    protected void collectGors() {
        for (GeneralizedOrderRequest gor : this.superplan.getGors()) {
            Product p = gor.getProduct();
            if (!gor.hasSelectedActiongram()) {
                gor.setActiongram(p.getDefaultActiongram());
            }
            ProductInfo info = this.getProductInfo(p);
            info.gors.add(gor);
        }
    }

    protected void collectCrs() {
        for (CustomerRequest cr : this.superplan.getCustomerRequests()) {
            CrDemand d = new CrDemand(cr.getTime() + (long)(cr.getPriority() - 5) * this.priorityShift, cr.getQty(), cr);
            if (cr.getMaterial() instanceof Product) {
                Product p = (Product)cr.getMaterial();
                ProductInfo info = this.getProductInfo(p);
                info.demands.add(d);
                continue;
            }
            MaterialInfo info = this.getMaterialInfo(cr.getMaterial());
            if (info == null) continue;
            info.demands.add(d);
        }
    }

    protected void initInfo(@Nonnull ProductInfo info, @Nonnull StoreSchedule ss) {
        Product p = info.product;
        info.stockQty += ss.getQ(p, this.superplan.getFixationDate(), true);
        if (p.getSafetyStock() > 0.0) {
            info.demands.add(new SsDemand(this.superplan.getFixationDate() + this.unaddressedShift, p.getSafetyStock()));
        }
        Mrp.sortDeque(info.demands, Comparator.comparingLong(demand -> demand.date));
        Mrp.sortDeque(info.gors, (x, y) -> {
            int cmp = Integer.compare(this.statesOrderingMap.get((Object)x.getState()), this.statesOrderingMap.get((Object)y.getState()));
            if (cmp != 0) {
                return cmp;
            }
            cmp = Long.compare(x.getDueDate(), y.getDueDate());
            if (cmp == 0 && this.mrpOrderGorPd != null) {
                Long xOrd = (Long)x.getProperty(this.mrpOrderGorPd);
                Long yOrd = (Long)y.getProperty(this.mrpOrderGorPd);
                cmp = Long.compare(xOrd == null ? 0L : xOrd, yOrd == null ? 0L : yOrd);
            }
            return cmp;
        });
    }

    @Nullable
    protected GeneralizedOrderRequest createGor(@Nonnull ProductInfo info) {
        String id;
        Product p = info.product;
        Demand demand = info.demands.getFirst();
        double qty = demand.qty - info.stockQty;
        if (p.getMinBatch() > 0.0) {
            qty = Math.max(qty, p.getMinBatch());
        }
        if (p.getBatchStep() > 0.0) {
            qty = p.getBatchStep() * Math.ceil(qty / p.getBatchStep());
        }
        do {
            id = p.getName() + ":" + info.gorIndex;
            ++info.gorIndex;
        } while (this.superplan.getGor(id) != null);
        GeneralizedOrderRequest newGor = new GeneralizedOrderRequest(id, p, qty, this.superplan.getFixationDate(), this.superplan.getFixationDate(), GeneralizedOrderRequest.State.PROPOSED);
        newGor.setActiongram(p.getDefaultActiongram());
        this.superplan.addGor(newGor);
        ++this.newGorsCnt;
        return newGor;
    }

    @Nonnull
    protected GeneralizedOrderRequest popGor(@Nonnull ProductInfo info) {
        GeneralizedOrderRequest gor = info.gors.removeFirst();
        Preconditions.checkState(gor.hasSelectedActiongram());
        boolean mainUsed = false;
        for (GeneralizedActionRequest gar : gor.getGars()) {
            double qty = gar.getRequestedQty() - gar.getOutOfPlanQty();
            if (!(qty > 0.0)) continue;
            for (MaterialQuantity mq : gar.getAction().getProduces()) {
                if (!(mq.getMaterial() instanceof Product)) continue;
                Product p = (Product)mq.getMaterial();
                ProductInfo pi = this.getProductInfo(p);
                pi.stockQty += mq.getQty() * qty;
                pi.stockSource = gar;
                mainUsed |= pi == info;
            }
        }
        if (!mainUsed) {
            info.stockQty += gor.getRequestedQty() - gor.getOutOfPlanQty();
            info.stockSource = Iterables.getLast(gor.getGars());
        }
        return gor;
    }

    protected void registerGor(@Nonnull GeneralizedOrderRequest gor, long dd) {
        gor.setDueDate(dd);
        gor.setPriority(5);
        if (this.mrpOrderGorPd != null) {
            gor.setProperty(this.mrpOrderGorPd, this.processedGorsCnt);
        }
        ++this.processedGorsCnt;
        long shift = 0L;
        for (GeneralizedActionRequest gar : Lists.reverse(gor.getGars())) {
            Action action = gar.getAction();
            gar.setDueDate(dd - shift);
            gar.setLatestPossibleStart(dd - (shift += action.timeToMake(gar.getRequestedQty())));
            double qty = gar.getRequestedQty() - gar.getOutOfPlanMat();
            if (qty > 0.0) {
                for (MaterialQuantity mq : action.getBom()) {
                    if (mq.getMaterial() instanceof Product) {
                        Product p = (Product)mq.getMaterial();
                        ProductInfo info = this.getProductInfo(p);
                        info.demands.add(new GarDemand(dd - shift - this.bomStepBuffer, mq.getQty() * qty, gar));
                        continue;
                    }
                    MaterialInfo info = this.getMaterialInfo(mq.getMaterial());
                    if (info == null) continue;
                    info.demands.add(new GarDemand(dd - shift - this.materialBuffer, mq.getQty() * qty, gar));
                }
            }
            shift += action.getMinTimeToPrepare() + this.opBuffer;
        }
    }

    protected void balanceSimple(@Nonnull ProductInfo info) {
        while (!info.demands.isEmpty()) {
            Demand demand = info.demands.getFirst();
            while (info.stockQty < demand.qty - 1.0E-7) {
                if (info.gors.isEmpty()) {
                    GeneralizedOrderRequest gor = this.createGor(info);
                    if (gor == null) {
                        return;
                    }
                    info.gors.add(gor);
                }
                this.registerGor(this.popGor(info), demand.date);
            }
            info.stockQty -= demand.qty;
            info.demands.removeFirst();
        }
        long unaddressedTime = this.superplan.getFixationDate() + this.unaddressedShift;
        for (GeneralizedOrderRequest gor : info.gors) {
            this.registerGor(gor, unaddressedTime);
        }
        info.gors.clear();
    }

    protected void balance(@Nonnull ProductInfo info) {
        long unaddressedTime = this.superplan.getFixationDate() + this.unaddressedShift;
        while (true) {
            double pairedQty;
            Demand demand;
            if ((demand = info.demands.peekFirst()) != null && demand.qty <= 1.0E-7) {
                Demand prevDemand = info.demands.removeFirst();
                demand = info.demands.peekFirst();
                if (demand != null) {
                    demand.qty += prevDemand.qty;
                }
            }
            while (info.stockQty <= 1.0E-7) {
                GeneralizedOrderRequest gor;
                if (info.gors.isEmpty()) {
                    if (demand == null) {
                        return;
                    }
                    gor = this.createGor(info);
                    if (gor == null) {
                        return;
                    }
                    info.gors.add(gor);
                }
                gor = this.popGor(info);
                this.registerGor(gor, demand != null ? demand.date : unaddressedTime);
            }
            if (demand != null) {
                pairedQty = Math.min(demand.qty, info.stockQty);
                demand.qty -= pairedQty;
            } else {
                pairedQty = info.stockQty;
            }
            Preconditions.checkState(pairedQty > 1.0E-7, "Strange paired qty: %s", (Object)pairedQty);
            info.stockQty -= pairedQty;
            this.pair(info.stockSource, demand, (Material)info.product, pairedQty);
        }
    }

    protected SupplyRequest createSr(MaterialInfo info) {
        String id;
        Material m3 = info.material;
        long t = info.demands.getFirst().date;
        if (GeneralizedRequest.isDateValid(m3.getMaterialHorizon()) && t < this.superplan.getFixationDate() + m3.getMaterialHorizon()) {
            t = this.superplan.getFixationDate() + m3.getMaterialHorizon();
        }
        double qty = -info.stockQty;
        ZoneId zone = ZoneId.systemDefault();
        ZonedDateTime srTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(t), zone).truncatedTo(ChronoUnit.DAYS);
        t = srTime.toInstant().toEpochMilli();
        long nextDemandT = srTime.plusDays(1L).toInstant().toEpochMilli();
        for (Demand d : info.demands) {
            if (d.date >= nextDemandT) break;
            qty += d.qty;
        }
        do {
            id = m3.getName() + ":" + info.srIndex;
            ++info.srIndex;
        } while (this.superplan.getSupplyRequest(id) != null);
        SupplyRequest sr = new SupplyRequest(id, m3, t, qty, SupplyRequest.State.PROPOSED);
        this.superplan.addSupplyRequest(sr);
        ++this.newSrsCnt;
        return sr;
    }

    protected void balance(@Nonnull MaterialInfo info) {
        if (info.material.getSafetyStock() > 0.0) {
            info.demands.add(new SsDemand(this.superplan.getFixationDate() + this.unaddressedShift, info.material.getSafetyStock()));
        }
        Mrp.sortDeque(info.srs, Comparator.comparingInt(sr -> sr.getState() == SupplyRequest.State.CONFIRMED ? 0 : 1).thenComparing(MaterialRequest::getTime).thenComparing(sr -> this.mrpOrderSrPd != null ? (Long)sr.getProperty(this.mrpOrderSrPd) : Long.valueOf(0L)).thenComparing(MaterialRequest::getId));
        Mrp.sortDeque(info.demands, Comparator.comparingLong(d -> d.date));
        SupplyRequest sr2 = null;
        while (true) {
            double pairedQty;
            Demand demand;
            if ((demand = info.demands.peekFirst()) != null && demand.qty <= 1.0E-7) {
                Demand prevDemand = info.demands.removeFirst();
                demand = info.demands.peekFirst();
                if (demand != null) {
                    demand.qty += prevDemand.qty;
                }
            }
            if (info.stockQty <= 1.0E-7) {
                if (info.srs.isEmpty()) {
                    if (demand == null) break;
                    info.srs.add(this.createSr(info));
                }
                sr2 = info.srs.removeFirst();
                if (this.mrpOrderSrPd != null) {
                    sr2.setProperty(this.mrpOrderSrPd, this.processedSrsCnt);
                }
                ++this.processedSrsCnt;
                info.stockQty += sr2.getQty();
            }
            if (demand != null) {
                pairedQty = Math.min(demand.qty, info.stockQty);
                demand.qty -= pairedQty;
            } else {
                pairedQty = info.stockQty;
            }
            Preconditions.checkState(pairedQty > 1.0E-7);
            info.stockQty -= pairedQty;
            this.pair(sr2, demand, info.material, pairedQty);
        }
    }

    protected void pair(@Nullable GeneralizedActionRequest gar, Demand demand, Material material, double qty) {
    }

    protected void pair(@Nullable SupplyRequest sr, Demand demand, Material material, double qty) {
    }

    protected void run() {
        log.info("MRP starts...");
        this.collectCrs();
        this.collectGors();
        this.toggleCrs(CustomerRequest.State.INACTIVE);
        StoreSchedule ss = this.superplan.getPlan().getStoreSchedule(StoreType.ACTUAL_ESTIMATE_VIEW);
        for (Product p : Lists.reverse(this.getSortedProducts())) {
            ProductInfo info = this.getProductInfo(p);
            this.initInfo(info, ss);
            this.balance(info);
        }
        this.collectSrs();
        for (MaterialInfo info : this.matInfoMap.values()) {
            this.balance(info);
        }
        this.toggleCrs(CustomerRequest.State.ACTIVE);
        log.info("Added {} GORs", (Object)this.newGorsCnt);
        log.info("Processed {} GORs on {} products", (Object)this.processedGorsCnt, (Object)this.prInfoMap.size());
        log.info("Added {} SRs", (Object)this.newSrsCnt);
        log.info("Processed {} SRs on {} materials", (Object)this.processedSrsCnt, (Object)this.matInfoMap.size());
    }

    public static void run(@Nonnull Superplan superplan) {
        new Mrp(superplan).run();
    }

    protected static <T> void sortDeque(@Nonnull Deque<T> deque, @Nonnull Comparator<T> cmp) {
        ArrayList<T> l = new ArrayList<T>(deque);
        deque.clear();
        l.sort(cmp);
        deque.addAll(l);
    }

    protected void toggleCrs(@Nonnull CustomerRequest.State state) {
        for (CustomerRequest cr : this.superplan.getCustomerRequests()) {
            cr.setState(state);
        }
    }

    @Nullable
    protected static PropertyDefinition optionalProperty(@Nonnull Superplan superplan, @Nonnull String name, @Nonnull Class<? extends Propertized> cls) {
        PropertyDefinition pd = superplan.getShopConf().getPropertyDefinition(cls, name);
        if (pd == null) {
            log.info("there is no {} property on {}", (Object)name, (Object)cls.getSimpleName());
        }
        return pd;
    }

    @Nonnull
    protected ProductInfo getProductInfo(Product p) {
        return this.prInfoMap.computeIfAbsent(p, ProductInfo::new);
    }

    @Nullable
    protected MaterialInfo getMaterialInfo(Material m3) {
        if (!m3.isConsumed()) {
            return null;
        }
        return this.matInfoMap.computeIfAbsent(m3, mat -> {
            StoreSchedule ss = this.superplan.getPlan().getStoreSchedule(StoreType.EXTERNAL);
            return new MaterialInfo((Material)mat, ss.getInfTimeQty((Material)mat));
        });
    }

    public static class MrpParameters {
        public EnumMap<GeneralizedOrderRequest.State, Integer> statesOrderingMap = this.initGorStatesOrdering();
        public long priorityShift = 604800000L;
        public long unaddressedShift = 157680000000L;
        public long opBuffer = 0L;
        public long bomStepBuffer = 86400000L;
        public long materialBuffer = 86400000L;

        @Nonnull
        protected EnumMap<GeneralizedOrderRequest.State, Integer> initGorStatesOrdering() {
            EnumMap<GeneralizedOrderRequest.State, Integer> statesOrderingMap = Maps.newEnumMap(GeneralizedOrderRequest.State.class);
            statesOrderingMap.put(GeneralizedOrderRequest.State.RUNNING, 1);
            statesOrderingMap.put(GeneralizedOrderRequest.State.PLANNING, 2);
            statesOrderingMap.put(GeneralizedOrderRequest.State.PROPOSED, 3);
            statesOrderingMap.put(GeneralizedOrderRequest.State.RELEASED, 4);
            statesOrderingMap.put(GeneralizedOrderRequest.State.WILL_BE_RELEASED, 4);
            statesOrderingMap.put(GeneralizedOrderRequest.State.VIRTUAL, 4);
            statesOrderingMap.put(GeneralizedOrderRequest.State.PAUSED, 4);
            return statesOrderingMap;
        }
    }

    protected static class MaterialInfo {
        public final Material material;
        public final Deque<Demand> demands;
        public final Deque<SupplyRequest> srs;
        public double stockQty;
        public int srIndex;

        public MaterialInfo(Material material, double initialQty) {
            this.material = material;
            this.stockQty = initialQty;
            this.demands = new ArrayDeque<Demand>();
            this.srs = new ArrayDeque<SupplyRequest>();
        }
    }

    protected static class ProductInfo {
        public final Product product;
        public int gorIndex;
        public double stockQty;
        public GeneralizedActionRequest stockSource;
        public Deque<Demand> demands;
        public Deque<GeneralizedOrderRequest> gors;

        protected ProductInfo(Product product) {
            this.product = Preconditions.checkNotNull(product);
            this.stockQty = 0.0;
            this.gorIndex = 0;
            this.demands = new ArrayDeque<Demand>();
            this.gors = new ArrayDeque<GeneralizedOrderRequest>();
        }
    }

    protected static class CrDemand
    extends Demand {
        public final CustomerRequest cr;

        protected CrDemand(long date, double qty, CustomerRequest cr) {
            super(date, qty);
            this.cr = cr;
        }

        public CustomerRequest getCr() {
            return this.cr;
        }
    }

    protected static class SsDemand
    extends Demand {
        protected SsDemand(long date, double qty) {
            super(date, qty);
        }
    }

    protected static abstract class Demand {
        public long date;
        public double qty;

        protected Demand(long date, double qty) {
            Preconditions.checkArgument(qty > 0.0, "demand quantity must be positive");
            this.date = date;
            this.qty = qty;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("date", this.date).add("qty", this.qty).toString();
        }
    }

    protected static class GarDemand
    extends Demand {
        public final GeneralizedActionRequest gar;

        protected GarDemand(long date, double qty, GeneralizedActionRequest gar) {
            super(date, qty);
            this.gar = gar;
        }

        public GeneralizedActionRequest getGar() {
            return this.gar;
        }
    }
}

